﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="PendingRequests.aspx.cs" Inherits="TravelManagerWeb.PendingRequests" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

  <asp:Panel ID="PanelList" runat="server">
      Zaznacz w kolejce element, który nie został zatwierdzony lub zamknięty. Użyj 
      przycisków, aby zatwierdzić lub odrzucić zgłoszenie.
  <br />
  <asp:Button ID="ButtonApprove" runat="server" Text="Zatwierdź zgłoszenie" 
      onclick="ButtonApprove_Click" />&nbsp;&nbsp;&nbsp;
  <asp:Button ID="ButtonReject" runat="server" Text="Odrzuć zgłoszenie" 
      onclick="ButtonReject_Click" />&nbsp;&nbsp;&nbsp;
  <asp:Button ID="ButtonRefresh" runat="server" Text="Odśwież" 
      onclick="ButtonRefresh_Click" />
  <hr />

  <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" 
    CellPadding="4" DataKeyNames="id" DataSourceID="TravelRequestDs" 
    ForeColor="#333333" GridLines="None" AllowPaging="True" PageSize="5">
    <AlternatingRowStyle BackColor="White" ForeColor="#284775" />
    <Columns>
      <asp:CommandField ShowSelectButton="True" SelectText="Zaznacz" />
      <asp:BoundField DataField="id" HeaderText="ID zgłoszenia" ReadOnly="True" 
        SortExpression="id" />
      <asp:BoundField DataField="name" 
        HeaderText="Tytuł" SortExpression="name" />
      <asp:BoundField DataField="workflowInstanceId" HeaderText="ID procesu" 
        SortExpression="workflowInstanceId" />
      <asp:BoundField DataField="requesterId" HeaderText="Zgłaszający" 
        SortExpression="requesterId" />
      <asp:BoundField DataField="creationDate" HeaderText="Data zgłoszenia" 
        SortExpression="creationDate" DataFormatString="{0:d}" />
      <asp:BoundField DataField="travelEstimate" HeaderText="Szacunkowy koszt" 
        SortExpression="travelEstimate" DataFormatString="{0:c}" />
      <asp:CheckBoxField DataField="isApproved" HeaderText="Zatwierdzono?" 
        SortExpression="isApproved" >
      <ItemStyle HorizontalAlign="Center" />
      </asp:CheckBoxField>
      <asp:CheckBoxField DataField="isComplete" HeaderText="Zamknięto?" 
        SortExpression="isComplete" >
      <ItemStyle HorizontalAlign="Center" />
      </asp:CheckBoxField>
      <asp:BoundField DataField="approvalManagerId" HeaderText="Zatwierdzający" 
        SortExpression="approvalManagerId" />
    </Columns>
    <EditRowStyle BackColor="#999999" />
    <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
    <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
    <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
    <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
    <SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" />
    <SortedAscendingCellStyle BackColor="#E9E7E2" />
    <SortedAscendingHeaderStyle BackColor="#506C8C" />
    <SortedDescendingCellStyle BackColor="#FFFDF8" />
    <SortedDescendingHeaderStyle BackColor="#6F8DAE" />
  </asp:GridView>
  <asp:SqlDataSource ID="TravelRequestDs" runat="server" 
    ConnectionString="<%$ ConnectionStrings:TravelRequest %>" 
    SelectCommand="SELECT * FROM [Request] ORDER BY [isComplete], [isApproved]"></asp:SqlDataSource>
  </asp:Panel>

  <asp:Panel ID="PanelComplete" Visible="false" runat="server">
    <table>
      <tr><td colspan="2"><hr /></td></tr>
      <tr><td><asp:Label ID="LabelResult" runat="server" Text=""></asp:Label></td></tr>
      <tr><td><br /><a href="PendingRequests.aspx">Kliknij, aby odświeżyć listę.</a></td></tr>
      <tr><td colspan="2"><hr /></td></tr>
    </table>
  </asp:Panel>

</asp:Content>
